(function () {

  const data = [
    {
      key: "Printing",
      cover: "assets/images/fabrisc/01.jpg",
      options: [
        { title:"Reactive Printing", text:"Cotton reactive print", thumb:"assets/images/fabrisc/02.jpg", full:"assets/images/fabrisc/02.jpg" },
        { title:"Pigment Printing", text:"All-fiber pigment print", thumb:"assets/images/fabrisc/03.jpg", full:"assets/images/fabrisc/03.jpg" },
        { title:"Special Finish", text:"Peach / sueding / enzyme", thumb:"assets/images/fabrisc/04.jpg", full:"assets/images/fabrisc/04.jpg" }
      ]
    },
    {
      key: "Fiber",
      cover: "assets/images/fabrisc/05.jpg",
      options: [
        { title:"Cotton", text:"100% cotton / blends", thumb:"assets/images/fabrisc/06.jpg", full:"assets/images/fabrisc/06.jpg" },
        { title:"Polyester", text:"Virgin / Recycled", thumb:"assets/images/fabrisc/07.jpg", full:"assets/images/fabrisc/07.jpg" },
        { title:"Viscose", text:"Rayon variants", thumb:"assets/images/fabrisc/08.jpg", full:"assets/images/fabrisc/08.jpg" },
        { title:"Spandex", text:"Elastane stretch", thumb:"assets/images/fabrisc/09.jpg", full:"assets/images/fabrisc/09.jpg" }
      ]
    },
    {
      key: "Fabrics",
      cover: "assets/images/fabrisc/10.jpg",
      options: [
        { title:"Knits", text:"Single jersey / rib", thumb:"assets/images/fabrisc/11.jpg", full:"assets/images/fabrisc/11.jpg" },
        { title:"Woven", text:"Poplin / twill", thumb:"assets/images/fabrisc/12.jpg", full:"assets/images/fabrisc/12.jpg" },
        { title:"Denim", text:"Indigo denim", thumb:"assets/images/fabrisc/13.jpg", full:"assets/images/fabrisc/13.jpg" }
      ]
    },
    {
      key: "Yarn",
      cover: "assets/images/fabrisc/07.jpg",
      options: [
        { title:"Spun Yarn", text:"Ring / OE", thumb:"assets/images/fabrisc/02.jpg", full:"assets/images/fabrisc/02.jpg" },
        { title:"POY", text:"Partially Oriented Yarn", thumb:"assets/images/fabrisc/03.jpg", full:"assets/images/fabrisc/03.jpg" },
        { title:"SDY", text:"Spun Drawn Yarn", thumb:"assets/images/fabrisc/04.jpg", full:"assets/images/fabrisc/04.jpg" },
        { title:"Textured", text:"DTY / ATY", thumb:"assets/images/fabrisc/05.jpg", full:"assets/images/fabrisc/05.jpg" }
      ]
    }
  ];

  function init() {
    const mount = document.getElementById("efp-chart-section");
    if (!mount) return;

    const uid = "efp_" + Math.random().toString(16).slice(2);

    mount.innerHTML = `
      <div class="efpChart">
        <div class="layout">
          <div class="circleWrap">
            <svg id="${uid}_chart" viewBox="0 0 520 520" aria-label="round chart"></svg>
          </div>

          <div class="panel">
            <div class="panelHead">
              <div class="panelTitle" id="${uid}_catTitle">Fiber</div>
              <div class="panelSub">Click a quarter to open full view</div>
            </div>
            <div class="list" id="${uid}_optionsList"></div>
          </div>
        </div>
      </div>

      <div id="${uid}_modal" class="efpChartModal" aria-hidden="true">
        <div class="modalCard" role="dialog" aria-modal="true">
          <div class="modalHead">
            <div class="modalTitle" id="${uid}_modalTitle">Category</div>
            <button class="close" id="${uid}_closeBtn">Close ✕</button>
          </div>

          <div class="modalBody">
            <div class="viewer">
              <img id="${uid}_mainImg" alt="" />
              <div class="cap" id="${uid}_mainCap"></div>
              <div class="subcap" id="${uid}_mainDesc"></div>
            </div>

            <div class="modalList">
              <h4 id="${uid}_modalListTitle">Items</h4>
              <div id="${uid}_modalItems"></div>
            </div>
          </div>
        </div>
      </div>
    `;

    const svg = document.getElementById(`${uid}_chart`);
    const catTitle = document.getElementById(`${uid}_catTitle`);
    const optionsList = document.getElementById(`${uid}_optionsList`);

    const modal = document.getElementById(`${uid}_modal`);
    const closeBtn = document.getElementById(`${uid}_closeBtn`);
    const modalTitle = document.getElementById(`${uid}_modalTitle`);
    const modalListTitle = document.getElementById(`${uid}_modalListTitle`);
    const modalItems = document.getElementById(`${uid}_modalItems`);
    const mainImg = document.getElementById(`${uid}_mainImg`);
    const mainCap = document.getElementById(`${uid}_mainCap`);
    const mainDesc = document.getElementById(`${uid}_mainDesc`);

    const svgns = "http://www.w3.org/2000/svg";
    const defs = document.createElementNS(svgns, "defs");
    svg.appendChild(defs);

    const cx = 260, cy = 260, r = 230;

    function makePattern(id, imgUrl) {
      const p = document.createElementNS(svgns, "pattern");
      p.setAttribute("id", id);
      p.setAttribute("patternUnits", "userSpaceOnUse");
      p.setAttribute("x", cx - r);
      p.setAttribute("y", cy - r);
      p.setAttribute("width", r * 2);
      p.setAttribute("height", r * 2);

      const img = document.createElementNS(svgns, "image");
      img.setAttribute("href", imgUrl);
      img.setAttribute("x", cx - r);
      img.setAttribute("y", cy - r);
      img.setAttribute("width", r * 2);
      img.setAttribute("height", r * 2);
      img.setAttribute("preserveAspectRatio", "xMidYMid slice");

      p.appendChild(img);
      defs.appendChild(p);
      return `url(#${id})`;
    }

    function quarterPath(pos) {
      const angles = [
        [Math.PI, 1.5 * Math.PI],
        [1.5 * Math.PI, 2 * Math.PI],
        [0.5 * Math.PI, Math.PI],
        [0, 0.5 * Math.PI]
      ];
      const [a1, a2] = angles[pos];
      const x1 = cx + r * Math.cos(a1), y1 = cy + r * Math.sin(a1);
      const x2 = cx + r * Math.cos(a2), y2 = cy + r * Math.sin(a2);
      return `M ${cx} ${cy} L ${x1} ${y1} A ${r} ${r} 0 0 1 ${x2} ${y2} Z`;
    }

    function labelPos(pos) {
      const centers = [
        { x: cx - r * 0.45, y: cy - r * 0.45 },
        { x: cx + r * 0.45, y: cy - r * 0.45 },
        { x: cx - r * 0.45, y: cy + r * 0.45 },
        { x: cx + r * 0.45, y: cy + r * 0.45 }
      ];
      return centers[pos];
    }

    function closeModal() {
      modal.classList.remove("open");
      modal.setAttribute("aria-hidden", "true");
      modalItems.innerHTML = "";
      mainImg.src = "";
    }

    function selectModalItem(opt, idx) {
      mainImg.src = opt.full;
      mainImg.alt = opt.title;
      mainCap.textContent = opt.title;
      mainDesc.textContent = opt.text || "";

      [...modalItems.querySelectorAll(".mItem")].forEach((el, i) => {
        el.classList.toggle("active", i === idx);
      });
    }

    function openCategoryModal(cat) {
      modal.classList.add("open");
      modal.setAttribute("aria-hidden", "false");
      modalTitle.textContent = cat.key;
      modalListTitle.textContent = `${cat.key} Options`;

      modalItems.innerHTML = "";
      cat.options.forEach((opt, idx) => {
        const div = document.createElement("div");
        div.className = "mItem";
        div.innerHTML = `
          <div class="thumbWrap"><img src="${opt.thumb}" alt=""></div>
          <div class="meta">
            <div class="name">${opt.title}</div>
            <div class="desc">${opt.text || ""}</div>
          </div>
        `;
        div.addEventListener("click", () => selectModalItem(opt, idx));
        modalItems.appendChild(div);
      });

      mainImg.src = cat.cover;
      mainCap.textContent = cat.key;
      mainDesc.textContent = "Select any option from the list";
      [...modalItems.querySelectorAll(".mItem")].forEach(el => el.classList.remove("active"));
    }

    function renderPreviewPanel(cat) {
      catTitle.textContent = cat.key;
      optionsList.innerHTML = "";
      cat.options.forEach((opt) => {
        const row = document.createElement("div");
        row.className = "efpRow";
        row.innerHTML = `
          <div class="thumbWrap"><img src="${opt.thumb}" alt=""></div>
          <div class="efpmeta">
            <div class="efpname">${opt.title}</div>
            <div class="efpdesc">${opt.text || ""}</div>
          </div>
        `;
        row.addEventListener("click", () => openCategoryModal(cat));
        optionsList.appendChild(row);
      });
    }

    closeBtn.addEventListener("click", closeModal);
    modal.addEventListener("click", (e) => { if (e.target === modal) closeModal(); });
    document.addEventListener("keydown", (e) => { if (e.key === "Escape") closeModal(); });

    data.forEach((cat, i) => {
      const fill = makePattern(`${uid}_pat_${i}`, cat.cover);

      const path = document.createElementNS(svgns, "path");
      path.setAttribute("d", quarterPath(i));
      path.setAttribute("fill", fill);
      path.setAttribute("class", "slice");
      path.setAttribute("stroke", "rgba(255,255,255,.9)");
      path.setAttribute("stroke-width", "3");

      path.addEventListener("click", () => {
        renderPreviewPanel(cat);
        openCategoryModal(cat);
      });

      svg.appendChild(path);

      const p = labelPos(i);
      const t = document.createElementNS(svgns, "text");
      t.setAttribute("x", p.x);
      t.setAttribute("y", p.y);
      t.setAttribute("class", "sliceText");
      t.textContent = cat.key;
      svg.appendChild(t);
    });

    const def = data.find(d => d.key === "Fiber") || data[1] || data[0];
    renderPreviewPanel(def);
  }

  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", init);
  } else {
    init();
  }
})();
