document.addEventListener('DOMContentLoaded', () => {
  // ========= Preloader =========
  window.addEventListener('load', () => {
    const preloader = document.getElementById('preloader');
    if (preloader) {
      preloader.style.opacity = '0';
      setTimeout(() => {
        preloader.style.display = 'none';
      }, 500);
    }
  });

  // ========= Hero Slider =========
  const slides = document.querySelectorAll('.video-slide');
const sliderNav = document.querySelector('.slider-nav');
let currentSlide = 0;
let isAnimating = false;
const animationDuration = 1000;
let slideInterval;

// ---- Generate dots dynamically based on number of slides ----
slides.forEach((_, index) => {
  const dot = document.createElement('div');
  dot.classList.add('slider-dot');
  if (index === 0) dot.classList.add('active');
  dot.dataset.slide = index;
  sliderNav.appendChild(dot);

  dot.addEventListener('click', () => {
    clearInterval(slideInterval);
    showHeroSlide(index);
    startAutoSlide();
  });
});

const heroDots = document.querySelectorAll('.slider-dot');

// ---- Show slide function ----
function showHeroSlide(n) {
  if (isAnimating || n === currentSlide) return;
  isAnimating = true;

  const prevSlide = slides[currentSlide];
  const nextSlide = slides[n];
  nextSlide.classList.add('active');

  setTimeout(() => {
    prevSlide.classList.remove('active');
    isAnimating = false;
  }, animationDuration);

  heroDots[currentSlide]?.classList.remove('active');
  heroDots[n]?.classList.add('active');
  currentSlide = n;
}

// ---- Auto slide ----
function startAutoSlide() {
  slideInterval = setInterval(() => {
    showHeroSlide((currentSlide + 1) % slides.length);
  }, 5000);
}

// ---- Start slider if slides exist ----
if (slides.length) {
  startAutoSlide();
}


  // Mobile menu open/close
  const menuToggle = document.getElementById("menuToggle");
  const menuClose = document.getElementById("menuClose");
  const mobileMenu = document.getElementById("mobileMenu");

  menuToggle.addEventListener("click", () => {
    document.body.classList.add("menu-open");
  });

  menuClose.addEventListener("click", () => {
    document.body.classList.remove("menu-open");
  });

  // Mobile dropdown open/close
  document.querySelectorAll(".mobile-drop-btn").forEach((btn) => {
    btn.addEventListener("click", () => {
      btn.nextElementSibling.classList.toggle("show");
    });
  });

  // ========= Counter =========
  const counters = document.querySelectorAll('.counter');
  if (counters.length) {
    counters.forEach(counter => {
      const target = +counter.getAttribute('data-target');
      let prefix = counter.textContent.replace(/[0-9]/g, '').trim();
      let suffix = counter.textContent.replace(/[0-9]/g, '').trim();
      let count = 0;
      const increment = target / 100;

      const updateCounter = () => {
        count += increment;
        if (count < target) {
          counter.textContent = prefix + Math.ceil(count) + suffix;
          requestAnimationFrame(updateCounter);
        } else {
          counter.textContent = prefix + target + suffix;
        }
      };
      updateCounter();
    });
  }

  // ========= Brand image slider =========
  $('.customer-logos').slick({
    slidesToShow: 8,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 0,          // continuous scroll
    speed: 8000,               // scroll speed (bigger = slower)
    cssEase: 'linear',         // smooth constant motion
    infinite: true,            // infinite loop
    arrows: false,
    dots: false,
    pauseOnHover: false,
    swipe: false,
    responsive: [
      { breakpoint: 768, settings: { slidesToShow: 4 } },
      { breakpoint: 520, settings: { slidesToShow: 3 } }
    ]
  });

});


// Slide show function
 document.querySelectorAll('.custom-slide-wrapper').forEach(wrapper => {
    let slides = wrapper.querySelectorAll('.custom-slide');
    let index = 0;

    setInterval(() => {
      // Remove active
      slides[index].classList.remove('active');

      // Reset animations
      let oldSlide = slides[index];
      oldSlide.querySelectorAll('.custom-text-overlay h5, .custom-text-overlay p').forEach(el => {
        el.style.opacity = 0;
        el.classList.remove('animate-fadeUp');
      });

      // Next slide
      index = (index + 1) % slides.length;
      let nextSlide = slides[index];
      nextSlide.classList.add('active');

      // Trigger animations sequentially
      setTimeout(() => {
        nextSlide.querySelector('.custom-text-overlay h5').classList.add('animate-fadeUp');
      }, 400);

      setTimeout(() => {
        nextSlide.querySelector('.custom-text-overlay p').classList.add('animate-fadeUp');
      }, 600);

    }, 3000);
  });



// product page area started
document.addEventListener('DOMContentLoaded', function() {
    const quoteButtons = document.querySelectorAll('.btn-quote');
    const modalProductName = document.getElementById('modalProductName');
    const quoteForm = document.getElementById('quoteForm');

    quoteButtons.forEach(button => {
      button.addEventListener('click', () => {
        modalProductName.textContent = button.getAttribute('data-product');
      });
    });

    // Category filtering
    const tabButtons = document.querySelectorAll('.nav-link');
    const productItems = document.querySelectorAll('.product-item');

    tabButtons.forEach(btn => {
      btn.addEventListener('click', () => {
        tabButtons.forEach(b => b.classList.remove('active'));
        btn.classList.add('active');

        const category = btn.getAttribute('data-category');
        productItems.forEach(item => {
          if (category === 'all' || item.getAttribute('data-category') === category) {
            item.style.display = 'block';
          } else {
            item.style.display = 'none';
          }
        });
      });
    });

    // Form submission
    quoteForm.addEventListener('submit', function(e) {
      e.preventDefault();
      // In a real application, you would send the form data to a server here
      alert('Thank you for your inquiry! We will get back to you soon.');
      const modal = bootstrap.Modal.getInstance(document.getElementById('quoteModal'));
      modal.hide();
      quoteForm.reset();
    });
  });



  // Gallery area

document.addEventListener("DOMContentLoaded", () => {
  const gallery = document.getElementById("gallery");

  const lightbox = document.getElementById("lightbox");
  const lightboxImg = document.getElementById("lightbox-img");
  const lightboxCaption = document.getElementById("lightbox-caption");
  const closeBtn = document.getElementById("close-btn");
  const prevBtn = document.getElementById("prev-btn");
  const nextBtn = document.getElementById("next-btn");

  const tabButtons = document.querySelectorAll(".tab-btn");
  const productCards = document.querySelectorAll(".product-gallery");

  let filteredCards = [];
  let currentIndex = 0;

  // ✅ Visible items list rebuild
  function rebuildFilteredCards() {
    filteredCards = Array.from(productCards).filter(
      (card) => !card.classList.contains("hidden")
    );
  }

  // ✅ Lightbox functions
  function openLightbox(index) {
    currentIndex = index;
    updateLightbox();
    lightbox.classList.add("active");
    document.body.style.overflow = "hidden";
  }

  function updateLightbox() {
    if (!filteredCards.length) return;
    const img = filteredCards[currentIndex].querySelector(".product-image");
    lightboxImg.src = img.src;
    lightboxImg.alt = img.alt;
    lightboxCaption.textContent = img.alt;
  }

  function closeLightbox() {
    lightbox.classList.remove("active");
    document.body.style.overflow = "auto";
  }

  function prevImage() {
    if (!filteredCards.length) return;
    currentIndex = (currentIndex - 1 + filteredCards.length) % filteredCards.length;
    updateLightbox();
  }

  function nextImage() {
    if (!filteredCards.length) return;
    currentIndex = (currentIndex + 1) % filteredCards.length;
    updateLightbox();
  }

  // ✅ Card click -> open lightbox (filtered list অনুযায়ী)
  productCards.forEach((card) => {
    card.addEventListener("click", () => {
      rebuildFilteredCards();
      const index = filteredCards.indexOf(card);
      if (index > -1) openLightbox(index);
    });
  });

  // ✅ Tab filter logic
  tabButtons.forEach((btn) => {
    btn.addEventListener("click", () => {
      tabButtons.forEach((b) => b.classList.remove("active"));
      btn.classList.add("active");

      const filter = btn.dataset.filter; // all / women / men / kids / accessories

      productCards.forEach((card) => {
        const cat = card.dataset.category;
        if (filter === "all" || cat === filter) {
          card.classList.remove("hidden");
        } else {
          card.classList.add("hidden");
        }
      });

      rebuildFilteredCards();
    });
  });

  // ✅ Lightbox controls
  closeBtn.addEventListener("click", closeLightbox);
  prevBtn.addEventListener("click", prevImage);
  nextBtn.addEventListener("click", nextImage);

  lightbox.addEventListener("click", (e) => {
    if (e.target === lightbox) closeLightbox();
  });

  document.addEventListener("keydown", (e) => {
    if (!lightbox.classList.contains("active")) return;

    if (e.key === "Escape") closeLightbox();
    if (e.key === "ArrowLeft") prevImage();
    if (e.key === "ArrowRight") nextImage();
  });

  // ✅ initial
  rebuildFilteredCards();
  console.log("Tabs + Lightbox ready!");
});






        










        